<?php
// Configurações de CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Responder a requisições OPTIONS (preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Iniciar sessão
session_start();

// Incluir conexão com base de dados
require_once 'db.php';

// Verificar autenticação
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Não autenticado']);
    exit();
}

try {
    $pdo = getConnection();
    
    // Criar tabela de entradas de produtos se não existir
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS product_entries (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            product_name TEXT NOT NULL,
            quantity INTEGER NOT NULL,
            entry_date DATE NOT NULL,
            entry_time TIME NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            user_id INTEGER,
            FOREIGN KEY (user_id) REFERENCES users (id)
        )
    ");
    
    $method = $_SERVER['REQUEST_METHOD'];
    
    switch ($method) {
        case 'GET':
            // Listar entradas recentes
            $stmt = $pdo->prepare("
                SELECT * FROM product_entries 
                ORDER BY entry_date DESC, entry_time DESC 
                LIMIT 20
            ");
            $stmt->execute();
            $entries = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode([
                'success' => true,
                'entries' => $entries
            ]);
            break;
            
        case 'POST':
            // Registar nova entrada
            $productName = $_POST['product_name'] ?? '';
            $quantity = $_POST['quantity'] ?? '';
            $entryDate = $_POST['entry_date'] ?? '';
            $entryTime = $_POST['entry_time'] ?? '';
            
            if (empty($productName) || empty($quantity) || empty($entryDate) || empty($entryTime)) {
                http_response_code(400);
                echo json_encode(['error' => 'Todos os campos são obrigatórios']);
                exit();
            }
            
            if (!is_numeric($quantity) || $quantity <= 0) {
                http_response_code(400);
                echo json_encode(['error' => 'Quantidade deve ser um número positivo']);
                exit();
            }
            
            // Inserir entrada na base de dados
            $stmt = $pdo->prepare("
                INSERT INTO product_entries (product_name, quantity, entry_date, entry_time, user_id) 
                VALUES (?, ?, ?, ?, ?)
            ");
            
            $result = $stmt->execute([
                $productName,
                (int)$quantity,
                $entryDate,
                $entryTime,
                $_SESSION['user_id']
            ]);
            
            if ($result) {
                // Verificar se o produto já existe na tabela de produtos
                $checkProduct = $pdo->prepare("SELECT id, stock FROM products WHERE name = ?");
                $checkProduct->execute([$productName]);
                $existingProduct = $checkProduct->fetch(PDO::FETCH_ASSOC);
                
                if ($existingProduct) {
                    // Atualizar stock do produto existente
                    $newStock = $existingProduct['stock'] + (int)$quantity;
                    $updateStock = $pdo->prepare("UPDATE products SET stock = ? WHERE id = ?");
                    $updateStock->execute([$newStock, $existingProduct['id']]);
                } else {
                    // Criar novo produto com o stock inicial
                    $insertProduct = $pdo->prepare("INSERT INTO products (name, stock) VALUES (?, ?)");
                    $insertProduct->execute([$productName, (int)$quantity]);
                }
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Entrada registada com sucesso!'
                ]);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Erro ao registar entrada']);
            }
            break;
            
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Método não permitido']);
            break;
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor: ' . $e->getMessage()]);
}
?>

